



<?php $__env->startSection('content'); ?>

<div class="content-wrapper">

    <!-- Content Header (Page header) -->

    <section class="content-header">

        <h1>

            Products

            <small></small>

        </h1>

        <ol class="breadcrumb">

            <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>

            <li class="active">Products</li>

        </ol>

    </section>

    <section class="content">

        <?php if(Session::has('successMsg')): ?>

        <div class="alert alert-success alert-dismissible">

            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>

            <h4><i class="icon fa fa-check"></i> <?php echo e(Session::get('successMsg')); ?></h4>

        </div>

        <?php echo e(Session::forget('successMsg')); ?>

        <?php endif; ?>

        <?php if(Session::has('errorMsg')): ?>

        <div class="alert alert-danger alert-dismissible">

            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>

            <h4><i class="icon fa fa-check"></i> <?php echo e(Session::get('errorMsg')); ?></h4>

        </div>

        <?php echo e(Session::forget('errorMsg')); ?>

        <?php endif; ?>

        <!--<div class="row">-->

        <!--    <div class="col-md-2">-->

        <!--        <a href="<?php echo e(route('add_product')); ?>" type="button" class="btn btn-block btn-primary">Add New Product</a>-->

        <!--    </div>-->

        <!--</div>-->

        <div class="custom-margin">

            <table id="product_list" class="table table-bordered table-hover display table-responsive">

                <thead>

                    <tr>

                        <th></th>

                        <th>Barcode</th>

                        <th>SKU</th>

                        <th>Name</th>

                        <th>Quantity</th>

                        <th>Last Updated Date</th>

                        <th>Action</th>

                        <th>Quantity</th>

                    </tr>

                </thead>

                <tbody>

                    <?php if(count($products)): ?>

                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                   <?php $left = "(";

                   $right = ")" ;

                   $replace = array($left,$right,"/",".","-",",","*");

                   $replacement = array(" "," "," or ","",""," ","X");?>

                    <tr>

                        <td></td>

                        <td class="print-barcode" id="print-barcode-id-<?php echo e(str_replace('+','plus',$product->sku)); ?>"><img  src='data:image/png;base64,<?php echo e(DNS1D::getBarcodePNG(substr($product->sku,0,45), "C128", 3, 33, array(1, 1, 1), true)); ?>' width="160px" height="50px" id="print-barcode-id-<?php echo e(str_replace('+','plus',$product->sku)); ?>-child"></td>

                        <td style='width="100px !important"'><?php echo e($product->sku); ?></td>

                        <td><?php echo e($product->name); ?></td>

                        <td>

                            <div class="custom-margin"><input type="text" value="<?php echo e($product->qty); ?>" name="table_qty[]" class="qty-box qty-box-<?php echo e(str_replace('+','plus',$product->sku)); ?>" style="width:40px">

                        <small class="help-block help-block-for-qty hide"  data-bv-for="qty_" data-bv-result="INVALID" style=""></small></div>

                        </td>

                        <td><?php echo e($product->updated_at); ?></td>

                        <td> 

                            <a href="<?php echo e(route('view_product_detail',$product->sku)); ?>" class="fa fa-eye" title="View Detail" style="color:orange"></a> 

                            <?php if($product->qty > 0): ?>

                            | <a href="#" class="fa fa-barcode custom-reprint-barcode custom-reprint-barcode<?php echo e($product->id); ?>" data-product="<?php echo e($product->id); ?>"  data-sku="<?php echo e($product->sku); ?>" data-qty="<?php echo e($product->qty); ?>" data-name ="<?php echo e($product->name); ?>" style="color:green" title="Re-print barcode" ></a> 

                            <?php endif; ?>

                            | <a class="fa fa-trash" style="color:red" title="Delete"></a></td>

                            <td><?php echo e($product->qty); ?></td>

                    </tr>

                    

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php endif; ?>

                </tbody>

                <tfoot>

            <tr>

                <th></th>

                <th></th>

                <th class="custom-searchable"></th>

                <th class="custom-searchable"></th>

                <th></th>

                <th class="custom-searchable"></th>

                <th></th>

            </tr>

        </tfoot>

            </table>

        </div>

    </section>

</div>

<!-- The Modal -->

<div class="modal" id="qtyModal">

  <div class="modal-dialog">

    <div class="modal-content">



      <!-- Modal Header -->

      <div class="modal-header">

        <h4 class="modal-title">How much barcode you want to re-print?</h4>

        <button type="button" class="close" data-dismiss="modal">&times;</button>

      </div>



      <!-- Modal body -->

      <div class="modal-body">

      <input type="hidden" name="modal_qty" id="modal_qty">

      <div class="custom-margin"><input class="form-control print-qty number-only-custom" type="number" placeholder="Quantity" name="qty_"  min='1' value='0'>

                    <small class="help-block help-block-for-qty hide"  data-bv-for="qty_" data-bv-result="INVALID" style=""></small>

                    </div>

       

      </div>



      <!-- Modal footer -->

      <div class="modal-footer">

        <button type="button" class="btn btn-alert modal-custom-reprint" data-dismiss="modal">Print</button>

      </div>



    </div> 

  </div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>





<script>

//updated on 21-11-20

$(document).on('keyup change','.qty-box',function(){

     var _this=$(this);

     var id = $(this).closest('tr').find('.fa-barcode').attr('data-product');

      $.ajax({

        method: 'get',

        url: "<?php echo e(route('check_quantity')); ?>",

        dataType: 'json',

        data: {id: id,

            qty: _this.val()

        },

        success: function (data) {

            console.log(data);

            if (data.length != 0) {



                if (data[0].isQty == 0) {

                    _this.closest('tr').find('.help-block-for-qty').removeClass('hide');

                    _this.closest('tr').find('.help-block-for-qty').html(data[0].message);

                     _this.closest('tr').find('.fa-barcode').removeClass('custom-reprint-barcode');

                    _this.val('');

                    _this.focus();



                } else {

                    _this.closest('tr').find('.help-block-for-qty').addClass('hide');

                    _this.closest('tr').find('.fa-barcode').addClass('custom-reprint-barcode');

                }

            } else {

                _this.closest('tr').find('.help-block-for-qty').removeClass('hide');

                _this.closest('tr').find('.help-block-for-qty').html('Something went wrong!');

                _this.val('');

                _this.focus();

            }

        },

        error: function (data) {

            console.log(data);

            console.log('something went wrong');

        }

    });

 });

$(document).on('click', '.custom-reprint-barcode', function () {



        var divContents_name = $(this).attr('data-name').substr(0,30);

        var sku = $(this).attr('data-sku');

        var divContents = $("#print-barcode-id-" + sku+'-child').attr('src');

        var qty = $(this).closest('tr').find('.qty-box').val();

        console.log(divContents);

        var doc = new jsPDF()

        var j = 0;

        var k=0;

        for (var i = 1; i <= qty; i++) {

            

                    doc.addImage(divContents, "png",10+(k*75),15+j , 40, 10)

                    doc.setFontSize(12);

                    doc.text(divContents_name,35+(k*75),30+j,null, null, "center");

                    k++;

                    if (i % 3 == 0) {

                         j=j+35;

                         k=0;

                    }

                    if(i % 24 == 0){

                        doc.addPage("a4", "p");

                        k=0;

                        j=0;

                    }

        }

      

        doc.save('tanna_techbiz.pdf');

        // console.log(qty);

        // var newWin = window.open('TannaTechBiz', 'Print-Window');

        // $( newWin.document).find('.cancel-button').css('display','none');

        // newWin.document.open();

        // newWin.document.write('<html>\n\

        //      <title>TannaTechBiz</title>\n\

        //      <body onload="window.print()">\n\

        //      <table><tr>');

        // for (var i = 1; i <= qty; i++) {

        //     newWin.document.write('<td style="padding:10px;text-align:center">' + divContents.innerHTML + '<br>' + divContents_name + '</td>');

        //     if (i % 3 == 0) {

        //         newWin.document.write('</tr><tr>');

        //     }

        // }

        // newWin.document.write('</tr></table>\n\

        //      </body>\n\

        //      </html>');

        // newWin.document.close();

        // setTimeout(function () {

        //     newWin.close();

        // }, 10);

    });







//commented on 21-11-20

// updated on 6-11-20



//  $(document).on('click', '.custom-reprint-barcode', function () {

//     var id = $(this).attr('data-product'); 

//     var qty = $(this).attr('data-qty'); 

//     $('#qtyModal').modal('show');

//     $('#qtyModal').find('.help-block-for-qty').addClass('hide');

//     $('#qtyModal').find('#modal_qty').val(id); 

//     $('#qtyModal').find('.print-qty').val(qty); 

//  });

 

//  $(document).on('keyup','.qty-box',function(){

//      var _this=$(this);

//      var id = $(this).closest('tr').find('.custom-reprint-barcode').attr('data-product');

//       $.ajax({

//         method: 'get',

//         url: "<?php echo e(route('check_quantity')); ?>",

//         dataType: 'json',

//         data: {id: id,

//             qty: _this.val()

//         },

//         success: function (data) {

//             console.log(data);

//             if (data.length != 0) {



//                 if (data[0].isQty == 0) {

//                     _this.closest('tr').find('.help-block-for-qty').removeClass('hide');

//                     _this.closest('tr').find('.help-block-for-qty').html(data[0].message);

//                      _this.closest('tr').find('.custom-reprint-barcode').prop('disabled', 'disabled');

//                     _this.val('');

//                     _this.focus();



//                 } else {

//                     _this.closest('tr').find('.help-block-for-qty').addClass('hide');

//                     _this.closest('tr').find('.custom-reprint-barcode').prop('disabled', '');

//                 }

//             } else {

//                 _this.closest('tr').find('.help-block-for-qty').removeClass('hide');

//                 _this.closest('tr').find('.help-block-for-qty').html('Something went wrong!');

//                 _this.val('');

//                 _this.focus();

//             }

//         },

//         error: function (data) {

//             console.log(data);

//             console.log('something went wrong');

//         }

//     });

//  });

 

//  $('#qtyModal').on('keyup', '.print-qty', function () {



//     var _this = $(this);

//     var id = $('#qtyModal').find('#modal_qty').val();

//     console.log(id);

//     console.log(_this.val());

    

//     $.ajax({

//         method: 'get',

//         url: "<?php echo e(route('check_quantity')); ?>",

//         dataType: 'json',

//         data: {id: id,

//             qty: _this.val()

//         },

//         success: function (data) {

//             console.log(data);

//             if (data.length != 0) {



//                 if (data[0].isQty == 0) {

//                     _this.parents('.custom-margin').find('.help-block-for-qty').removeClass('hide');

//                     _this.parents('.custom-margin').find('.help-block-for-qty').html(data[0].message);

//                     $(document).find('.modal-custom-reprint').prop('disabled', 'disabled');

//                     _this.val('');

//                     _this.focus();



//                 } else {

//                     _this.parents('.custom-margin').find('.help-block-for-qty').addClass('hide');

//                     $(document).find('.modal-custom-reprint').prop('disabled', '');



//         var divContents_name = $(document).find('.custom-reprint-barcode'+id).attr('data-name',qty);

//                 }

//             } else {

//                 _this.parents('.custom-margin').find('.help-block-for-qty').removeClass('hide');

//                 _this.parents('.custom-margin').find('.help-block-for-qty').html('Something went wrong!');

//                 _this.val('');

//                 _this.focus();

//             }

//         },

//         error: function (data) {

//             console.log(data);

//             console.log('something went wrong');

//         }

//     });

// });



//   $(document).on('click', '.modal-custom-reprint', function () {

//         var find_id = $('#qtyModal').find('#modal_qty').val();



//         var divContents_name = $(document).find('.custom-reprint-barcode'+find_id).attr('data-name');

//         var sku = $(document).find('.custom-reprint-barcode'+find_id).attr('data-sku');

//         var divContents = document.getElementById("print-barcode-id-" + sku);

//         var qty = $('#qtyModal').find('.print-qty').val();

        

//         var newWin = window.open('TannaTechBiz', 'Print-Window');

//         $( newWin.document).find('.cancel-button').css('display','none');

//         newWin.document.open();

//         newWin.document.write('<html>\n\

//              <title>TannaTechBiz</title>\n\

//              <body onload="window.print()">\n\

//              <table><tr>');

//         for (var i = 1; i <= qty; i++) {

//             newWin.document.write('<td style="padding:10px;text-align:center">' + divContents.innerHTML + '<br>' + divContents_name + '</td>');

//             if (i % 3 == 0) {

//                 newWin.document.write('</tr><tr>');

//             }

//         }

//         newWin.document.write('</tr></table>\n\

//              </body>\n\

//              </html>');

//         newWin.document.close();

//         setTimeout(function () {

//             newWin.close();

//         }, 10);

//     });

//end updated on 6-11-20

   //end commented on 21-11-20

 

    

//commented on 6-11-20

    // $(document).on('click', '.custom-reprint-barcode', function () {



    //     var divContents_name = $(this).attr('data-name');

    //     var sku = $(this).attr('data-sku');

    //     var divContents = document.getElementById("print-barcode-id-" + sku);

    //     var qty = $(this).attr('data-qty');

    //     console.log(divContents_name);

    //     console.log(divContents);

    //     console.log(qty);

    //     console.log(sku);

    //     var newWin = window.open('TannaTechBiz', 'Print-Window');

    //     $( newWin.document).find('.cancel-button').css('display','none');

    //     newWin.document.open();

    //     newWin.document.write('<html>\n\

    //          <title>TannaTechBiz</title>\n\

    //          <body onload="window.print()">\n\

    //          <table><tr>');

    //     for (var i = 1; i <= qty; i++) {

    //         newWin.document.write('<td style="padding:10px;text-align:center">' + divContents.innerHTML + '<br>' + divContents_name + '</td>');

    //         if (i % 3 == 0) {

    //             newWin.document.write('</tr><tr>');

    //         }

    //     }

    //     newWin.document.write('</tr></table>\n\

    //          </body>\n\

    //          </html>');

    //     newWin.document.close();

    //     setTimeout(function () {

    //         newWin.close();

    //     }, 10);

    // });

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tannatech/public_html/cpq/resources/views/products/list.blade.php ENDPATH**/ ?>