

<?php $__env->startSection('content'); ?>
<style>
    .custom-margin{
        margin-top: 10px;
        margin-bottom: 10px;
    }
    .custom-fa-refresh{
        font-size: 30px !important;
    }
    .custom-box{
        position: relative !important;
        border-radius: 0px !important;
        background: unset !important;
        border-top: unset !important;
        margin-bottom: 20px !important;
        width: 100%!important;
        box-shadow: unset !important;
    }

    .help-block{
        color: red !important;
        font-weight: 600 !important;
    }
</style>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Products
            <small>Disaptch Product</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo e(route('products')); ?>">Products</a></li>
            <li class="active">Dispatch</li>
        </ol>
    </section>
    <section class="content">
        <div class="box-body">
            <?php echo e(Form::open(['route'=>'save_dispatch_product','method'=>'post','id'=>'dispatch_product'])); ?>

            <div class="row">
                <div class="col-md-3">
                    <label>SKU</label>
                </div>
                <div class="col-md-3">
                    <label>Name</label>
                </div>
                <div class="col-md-3">
                        <label>Invoice No</label>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>Quantity</label>
                    </div>
                </div>
            </div>
            <div class="row custom-margin box custom-box">
                <div class="overlay custom-loader hide">
                    <i class="fa fa-refresh fa-spin custom-fa-refresh"></i>
                </div>
                <div class="col-md-3">
                    <input class="form-control sku" type="text" placeholder="SKU" name="sku_[]" autofocus="">
                    <small class="help-block help-block-for-sku hide" data-bv-for="sku_[]" data-bv-result="INVALID" style=""></small>

                </div>
                <div class="col-md-3">
                    <input class="form-control product_name" type="text" placeholder="Name" name="product_name_[]" readonly="">
                </div>
                <div class="col-md-3">
                    <input class="form-control invoice-number" type="text" placeholder="Invoice Number" name="invoice_number_[]" >
                    <small class="help-block help-block-for-invoice hide" data-bv-for="invoice_number_[]" data-bv-result="INVALID" style=""></small>
                </div>
                <div class="col-md-2">
                    <input class="form-control print-qty number-only-custom" type="number" placeholder="Quantity" name="qty_[]"  min='1' value='0'>
                    <small class="help-block help-block-for-qty hide"  data-bv-for="qty_[]" data-bv-result="INVALID" style=""></small>
                </div>
                <div class="col-md-1">
                    <button type="button" class="btn btn-default add-button hide"><i class="fa fa-plus"></i></button>
                </div>
                <input type="hidden" name="product_id[]" class="product-id">
            </div>
            <div class="row hide custom-margin box custom-box" id="optionTemplate">
                <div class="overlay custom-loader hide">
                    <i class="fa fa-refresh fa-spin custom-fa-refresh"></i>
                </div>
                <div class="col-md-3">
                    <input class="form-control sku" type="text" placeholder="SKU" name="sku_[]" autofocus="">
                    <small class="help-block help-block-for-sku hide" data-bv-for="sku_[]" data-bv-result="INVALID" style=""></small>
                </div>
                <div class="col-md-3">
                    <input class="form-control product_name" type="text" placeholder="Name" name="product_name_[]" readonly="">
                </div>
                <div class="col-md-3">
                    <input class="form-control invoice-number" type="text" placeholder="Invoice Number" name="invoice_number_[]" >
                    <small class="help-block help-block-for-invoice hide" data-bv-for="invoice_number_[]" data-bv-result="INVALID" style=""></small>
                </div>
                <div class="col-md-2">
                    <input class="form-control print-qty number-only-custom" type="number" placeholder="Quantity" name="qty_[]" min='1'  value='0'>
                    <small class="help-block help-block-for-qty hide" data-bv-for="qty_[]" data-bv-result="INVALID" style=""></small>
                </div>
                <div class="col-md-1">
                    <button type="button" class="btn btn-default add-button hide"><i class="fa fa-plus"></i></button>
                </div>
                <input type="hidden" name="product_id[]" class="product-id">
            </div>
            <div class="row">

                <div class="col-md-2">
                    <button  type="submit" class="btn btn-block btn-primary custom-save">Save</button>
                </div>
                <div class="col-md-2">
                    <a  href="<?php echo e(route('inventory')); ?>" type="button" class="btn btn-block btn-danger button-cancel">Cancel</a>
                </div>
            </div>

            <?php echo e(Form::close()); ?>

        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
<script>$(document).ready(function(){	var isTrue = false;	$(document).on('click','.custom-save',function(){		isTrue = true;	});	$(document).on('submit','#dispatch_product',function(e){	if(!isTrue){	e.preventDefault();	}});});

//on change sku finds product name
$(document).on('change', '.sku', function (e) {	
    var sku = $(this).val();
    var _this = $(this);
    console.log(sku);	
    $.ajax({
        method: 'get',
        url: "<?php echo e(route('search_product','sku_')); ?>",
        dataType: 'json',
        data: {q: sku},
        success: function (data) {
            if (data.length !== 0) {
                _this.parents('.custom-margin').find('.custom-loader').removeClass('hide');
                _this.parents('.custom-margin').find('.help-block-for-sku').addClass('hide');

                setTimeout(function () {
                    _this.parents('.custom-margin').find('.product_name').val(data[0].text);
                    _this.parents('.custom-margin').find('.product-id').val(data[0].id);
                    _this.parents('.custom-margin').find('.print-qty').val('0');
                    _this.parents('.custom-margin').find('.invoice-number').focus();
                    
                    _this.prop('readonly', 'readonly');
                    
                    _this.parents('.custom-margin').find('.custom-loader').addClass('hide');					
                }, 2000);
                $(document).find('.custom-save').prop('disabled', '');
            } else {
                _this.parents('.custom-margin').find('.help-block-for-sku').html('No product with this sku!');
                _this.parents('.custom-margin').find('.help-block-for-sku').removeClass('hide');
                $(document).find('.custom-save').prop('disabled', 'disabled');
            }
        },
        error: function (data) {
            console.log('something went wrong');
        }
    });
});
$('#dispatch_product').bootstrapValidator({
    fields: {
        'sku_[]': {
            validators: {
                notEmpty: {
                    message: 'sku required!'
                },
            }
        },
        'qty_[]':{			
			validators: {   
				notEmpty: {  
					message: 'Quantity required'  
				},  
			}
		},
        'invoice_number_[]': {
            validators: {
                notEmpty: {
                    message: 'invoice number required!'
                },
            }
        }
    }
})
        .on('click', '.add-button', function () {
            $(this).removeClass('add-button').addClass('remove-button');
            $(this).parent().find('i').removeClass('fa-plus').addClass('fa-minus');
            $(document).find('#optionTemplate .sku').focus();
            var $template = $('#optionTemplate'),
                    $clone = $template.clone()
                    .removeClass('hide')
                    .removeAttr('id')
                    .insertBefore($template),
                    $option = $clone.find('[name="product_name_[]"]');
            $option2 = $clone.find('[name="sku_[]"]');
            $option3 = $clone.find('[name="qty_[]"]');
            // Add new field
            $('#dispatch_product').bootstrapValidator('addField', $option);
            $('#dispatch_product').bootstrapValidator('addField', $option2);
            $('#dispatch_product').bootstrapValidator('addField', $option3);
            $($clone).find(".sku").focus();
        })
        .on('click', '.remove-button', function () {
            var $row = $(this).parents('.custom-margin')
//                $option = $row.find('[name="item_code[]"]');

            // Remove element containing the option
            $row.remove();
            // Remove field
//                $('#receiveItem').bootstrapValidator('removeField', $option);
//                $('#total_remove').val($('#total_remove').val() - 1);
        });


//check if entered qty is available.
$(document).on('keyup', '.print-qty', function () {

    var _this = $(this);
    console.log(_this.parents('.custom-margin').find('.product-id').val());
    $.ajax({
        method: 'get',
        url: "<?php echo e(route('check_quantity')); ?>",
        dataType: 'json',
        data: {id: _this.parents('.custom-margin').find('.product-id').val(),
            qty: _this.val()
        },
        success: function (data) {
            if (data.length != 0) {

                if (data[0].isQty == 0) {
                    _this.parents('.custom-margin').find('.help-block-for-qty').removeClass('hide');
                    _this.parents('.custom-margin').find('.help-block-for-qty').html(data[0].message);
                    $(document).find('.custom-save').prop('disabled', 'disabled');
                    _this.val('');
                    _this.focus();

                } else {
                    _this.parents('.custom-margin').find('.help-block-for-qty').addClass('hide');
                    $(document).find('.custom-save').prop('disabled', '');
                }
            } else {
                _this.parents('.custom-margin').find('.help-block-for-qty').removeClass('hide');
                _this.parents('.custom-margin').find('.help-block-for-qty').html('Something went wrong!');
                _this.val('');
                _this.focus();
            }
        },
        error: function (data) {
            console.log(data);
            console.log('something went wrong');
        }
    });
});


$(document).on('keyup', '.invoice-number', function (e) {	
    var invoice = $(this).val();
    var _this = $(this);
    var pid =  _this.parents('.custom-margin').find('.product-id').val();	
    console.log(pid);
    $.ajax({
        method: 'get', 
        url: "<?php echo e(route('search_invoice')); ?>",
        dataType: 'json',
        data: {invoice: invoice ,id:pid },
        success: function (data) {
            console.log(data);
            if (data.valid) {
                 _this.parents('.custom-margin').find('.help-block-for-invoice').addClass('hide');
                $(document).find('.custom-save').prop('disabled', '');
                 _this.parents('.custom-margin').find('.print-qty').prop('disabled', '');
                 _this.parents('.custom-margin').find('.add-button').removeClass('hide');
            } else {
                 _this.parents('.custom-margin').find('.add-button').addClass('hide');
                _this.parents('.custom-margin').find('.help-block-for-invoice').html(data.message);
                _this.parents('.custom-margin').find('.help-block-for-invoice').removeClass('hide');
                _this.parents('.custom-margin').find('.print-qty').prop('disabled', 'disabled');
                $(document).find('.custom-save').prop('disabled', 'disabled');
            }
        },
        error: function (data) {
            console.log('something went wrong');
        }
    });
});

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tannatech/public_html/cpq/resources/views/inventory/dispatchView.blade.php ENDPATH**/ ?>