

<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Products
            <small></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo e(route('products')); ?>"><i class="fa fa-dashboard"></i> Products</a></li>
            <li class="active">View</li>
        </ol>
    </section>
    <section class="content">
        <div>
            <?php if(Session::has('successMsg')): ?>
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <h4><i class="icon fa fa-check"></i> <?php echo e(Session::get('successMsg')); ?></h4>
            </div>
            <?php echo e(Session::forget('successMsg')); ?>

            <?php endif; ?>
            <?php if(Session::has('errorMsg')): ?>
            <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <h4><i class="icon fa fa-check"></i> <?php echo e(Session::get('errorMsg')); ?></h4>
            </div>
            <?php echo e(Session::forget('errorMsg')); ?>

            <?php endif; ?>
            <table id="product_list_detailed" class="table table-bordered table-hover display">
                <thead>
                    <tr>
                        <th>SKU</th>
                        <th>Name</th>
                        <th>Quantity Received</th>
                        <th>Quantity Dispatch</th>
                        <th>Quantity Sattlement</th>
                        <th>Added By</th>
                        <th>Type</th>
                        <th>Invoice No</th>
                        <th>Invoice Date</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tfoot>
            <tr>
                <th colspan="2"> Total:</th>
                <th id="received_tot"></th>
                <th id="dispatch_tot"></th>
                <th id="sattelent_tot"></th>
                <th colspan="4"></th>
            </tr>
        </tfoot>
                <tbody>
                    <?php if(($products)): ?>
                    <?php $__currentLoopData = $products->inventory_rec_dis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($products->sku); ?></td>
                        <td><?php echo e($products->name); ?></td>
                        <?php if($value->type == 'receive'): ?>
                        <td><?php echo e($value->quantity); ?></td>
                        <?php else: ?>
                        <td>-</td>
                        <?php endif; ?>
                        <?php if($value->type == 'dispatch'): ?>
                        <td><?php echo e($value->quantity); ?></td>
                        <?php else: ?>
                        <td>-</td>
                        <?php endif; ?>
                        <?php if($value->type == 'sattlement'): ?>
                        <td><?php echo e($value->quantity); ?></td>
                        <?php else: ?>
                        <td>-</td>
                        <?php endif; ?>
                        <td><?php echo e(ucfirst($value->scanned_by)); ?></td>
                        <td><?php echo e(ucfirst($value->type)); ?></td>
                        <td><?php echo e($value->invoice_no); ?></td>
                        <td><?php echo e($value->date); ?></td>
                        <td><?php if(!($value->type == 'sattlement')): ?>
                            <a href="<?php echo e(route('edit_product',[$value->id,$value->type])); ?>" class="fa fa-edit" title="Edit">
                                <?php endif; ?>
                            </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                    <tr>No records found</tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tannatech/public_html/cpq/resources/views/products/view.blade.php ENDPATH**/ ?>