@extends('layouts.main')





@section('content')

<section class="content-header">
    <h1>Edit User</h1>
    <ol class="breadcrumb">
        <li><a href="/home"><i class="fa fa-dashboard"></i>Home</a></li>
        <li><a href="#">Management</a></li>
        <li><a href="/users">Users</a></li>
        <li class="active"><a href="#">Edit</a.</li>
    </ol>
</section>
<hr style="border: 3px groove #3c8dbc;">

@if (count($errors) > 0)
    <div class="alert alert-danger">
        <strong>
        Whoops!
        </strong> There were some problems with your input.<br><br>
            <ul>
                @foreach ($errors->all() as $error)
                  <li>{{ $error }}</li>
                @endforeach
            </ul>
    </div>
@endif


<section  class="content" >
    <div class="row"> 
        <div class="col-md-6">
            <div class="box box-primary">
                
            {!! Form::model($user, ['method' => 'PATCH','route' => ['users.update', $user->id]]) !!}
                <div class="box-body">
                    
                    <div class="form-group">
                        <label for="exampleInputEmail1">Name:</label>
                            {!! Form::text('name', null, array('placeholder' => 'Name','class' => 'form-control')) !!}
                    </div>
                    
                    <div class="form-group">
                        <label for="exampleInputEmail1">Email:</label>
                            {!! Form::text('email', null, array('placeholder' => 'Email','class' => 'form-control')) !!}
                    </div>
                    
                    <div class="form-group">
                        <label for="exampleInputEmail1">Password:</label>
                            {!! Form::password('password', array('placeholder' => 'Password','class' => 'form-control')) !!}
                    </div>
                    
                    <div class="form-group">
                        <label for="exampleInputEmail1">Confirm Password:</label>
                            {!! Form::password('confirm-password', array('placeholder' => 'Confirm Password','class' => 'form-control')) !!}
                    </div>
                    
                    <div class="form-group">
                        <label for="exampleInputEmail1">Role:</label>
                            {!! Form::select('roles[]', $roles,$userRole, array('class' => 'form-control','multiple')) !!}
                    </div>
                </div>
                
                <div class="box-footer">
                    <a class="btn btn-primary" href="{{ route('users.index') }}"> Back</a>
                    <button type="submit" class="btn btn-primary pull-right">Submit</button>
                </div>
            </div>
        </div>
    </div>
</section>
{!! Form::close() !!}







@endsection