@extends('layouts.main')

@section('content')
 

<section class="content-header">
	
	<h1>Invoice Management</h1>
    
	<ol class="breadcrumb">
        
		<li><a href="/home"><i class="fa fa-dashboard"></i>Home</a></li>
        
		<li><a href="#">Invoice</a></li>
	
	</ol>

</section>

<hr style="border: 3px groove #3c8dbc;">

<section class="content">

	<div class="row">
	
		<div class="col-xs-12">
		
			<div class="box box-info">
			
				<div class="box-header">

					<div class="alert alert-success hide" id="invoice_success"></div>
                
					<div class="alert alert-danger hide" id="invoice_danger"></div>
					
					<a class="btn btn-primary" href="{{ route('home') }}"> Back</a>
					<span class="dropdown">
					<button type="button" class="btn btn-warning dropdown-toggle" data-toggle="dropdown">Action
                    <span class="fa fa-caret-down"></span></button>
                  <ul class="dropdown-menu">
                    <li><a class="invoice_trash" href="#">Trash</a></li>
                    <li>
						@can('invoice-pdf')
						<a class="invoice_shippdf" href="#"> PDF Lable for Maruti </a>
						@endcan
					</li>
                    <li>
						@can('invoice-excel')
						<a class="invoice_shipexcel" href="#" data-create="{{ Auth::user()->id }}"> Excel for Bluedart Label </a>
						@endcan
					</li>
                    <li><a class="invoice_cancel" href="#">Cancel</a></li>
                  </ul>
				  </span>
					
					@can('invoice-create')
					<span class="dropdown pull-right ">
					<button type="button" class="btn btn-info dropdown-toggle  " data-toggle="dropdown">Invoice
                    <span class="fa fa-caret-down"></span></button>
					  <ul class="dropdown-menu pull-right ">
						<li>
						<a class="invoice_createbtn" href="#"> New Invoice</a>
						</li>
						<li>
							<a class="invoice_createbtn_without_PI"  data-id="cpq" href="#" style="margin-right:10px"> New Invoice without PI </a>

						</li>
						<li>
							<a class="invoice_createbtn_without_PI" data-id="ttb" href="#" style="margin-right:10px"> New Invoice for Website </a>

						</li>
					  </ul>
					
					</span>
					
					@endcan

				
					@if ($message = Session::get('success'))
				
						<div class="alert alert-success">
							<p>{{ $message }}</p>
						</div>
					
					@endif
				
				</div>
				
				<div class="box-body">
				
					<table class="dataTables_wrapper table table-responsive" id="invoice_home">
					
						<thead>
						
							<tr>

								<th class="txt-center"></th>
							
								<th class="txt-center">No</th>
								
								<th class="txt-center">Invoice No</th>
								
								<th class="txt-center">PI NO</th>
								
								<th class="txt-center">Company name</th>

								<th class="txt-center">Tracking Details</th>

								<th class="txt-center">Serial NO</th>
								
								<th class="txt-center">Action</th>
								<th class="txt-center">Status</th>

								<th class="txt-center">Created Date</th>
							
							</tr>
						
						</thead>
						
						<tbody>
						
						@foreach($invoice as $data)
							<tr>
							
								<td class="txt-center"><input type="checkbox" class="invoice-check" name="invoice_shipcheck" id="invoice_shipcheck" data-id="{{ $data->id }}"></td>

								<td class="txt-center"></td>
								
								<td class="txt-center">{{ $data->invoice_no }}</td>
								
								<td class="txt-center">{{ $data->pi_no }}</td>
								
								
								<td class="txt-center">{{ $data->name }}</td>
									
								@if($data->courier_name=="null")									
									<td class="txt-center"><a class="btn btn-success {{$data->invoice_status !='Canceled' ? 'invoice_shipping' :""}}" data-id="{{ $data->id }}" {{$data->invoice_status =='Canceled' ? 'disabled' :""}}> Add Tracking Details</a></td>
								@else
									<td class="txt-center"><a class="btn btn-info {{$data->invoice_status !='Canceled' ? 'invoice_shipping' :""}}"  data-id="{{ $data->id }}" {{$data->invoice_status =='Canceled' ? 'disabled' :""}}> Tracking Details</a></td>
								@endif
								@if($data->isSerialNo)		
								<td class="txt-center"><a class="btn btn-info {{$data->invoice_status !='Canceled' ? 'invoice_serialno' :""}}" data-id="{{ $data->id }}" {{$data->invoice_status =='Canceled' ? 'disabled' :""}}>Serial No</a></td>
								@else
								<td class="txt-center"><a class="btn btn-primary {{$data->invoice_status !='Canceled' ? 'invoice_serialno' :""}}" data-id="{{ $data->id }}" {{$data->invoice_status =='Canceled' ? 'disabled' :""}}> Add Serial No</a></td>
								@endif
								
								<td class="txt-center">
                                    <a href="#" class="invoice_printbtn" data-id="{{'v'.$data->id}}"><i class="fa fa-eye orange"></i></a>|
									@can('invoice-print')
                                    <a data-id="{{'p'.$data->id }}" class="invoice_printbtn"><i class="fa fa-download orange"></i></a>|
									@endcan
									@can('invoice-mail')
                                    <a data-id="{{ $data->id }}"  {{$data->invoice_status !="Canceled" ? 'class=invoice_mailbtn' :""}}><i class="fa fa-envelope {{$data->invoice_status !="Canceled" ? 'orange' :'black'}}"></i></a>
									@endcan
									@can('invoice-delete')
									    @if($data->path =="" )
                                    	<a data-id="{{ $data->id }}" {{$data->invoice_status !="Canceled" ? 'class=invoice_trashbtn' :""}}><i class="fa fa-trash {{$data->invoice_status !="Canceled" ? 'orange' :'black'}}"></i></a>
									    @endif
									@endcan
									@if($data->path!="" )
									| <a data-id="{{ $data->id }}" class="invoice_downloadjson" href="{{($data->path)&&($data->invoice_status !="Canceled") ?$data->path : '#' }}" {{($data->path!="")&&($data->invoice_status !="Canceled") ?  'download' : ''}}><i class="fa fa-print {{$data->invoice_status !="Canceled" ? 'orange' :'black'}}"></i></a>
                                    @endif
								</td>

								<td class="txt-center">{{ $data->invoice_status }}</td>
								<td class="txt-center">{{ $data->created_at }}</td>

							</tr>

						@endforeach
						
						</tbody>
					
					</table>
				
				</div>
			
			</div>
		
		</div>
	
	</div>

</section>

			 
@include('invoices.create')
@include('invoices.trash')
@include('invoices.printoption')
@include('invoices.mail')
@include('invoices.printformate')
@include('invoices.printlabel')
@include('invoices.printlabelexcel')
@include('invoices.tracking')
@include('invoices.serial_no')


@include('invoices.Ind_Invoice.create')

			
@endsection

