@extends('layouts.main')
@section('content')


    <!-- Content Header (Page header) -->

    <section class="content-header">

        <h1>

            Print Barcode

            <small></small>

        </h1>

        <ol class="breadcrumb">

            <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

            <li class="active">Print Barcode</li>

        </ol>

    </section>

    <section class="content">

        @if(Session::has('successMsg'))

        <div class="alert alert-success alert-dismissible">

            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>

            <h4><i class="icon fa fa-check"></i> {{Session::get('successMsg')}}</h4>

        </div>

        {{Session::forget('successMsg')}}

        @endif

        @if(Session::has('errorMsg'))

        <div class="alert alert-danger alert-dismissible">

            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>

            <h4><i class="icon fa fa-check"></i> {{Session::get('errorMsg')}}</h4>

        </div>

        {{Session::forget('errorMsg')}}

        @endif

        <div class="custom-margin">

            <table id="print_barcode" class="table table-bordered table-hover display">

                <thead>

                    <tr>

                        <th></th>

                        <th>Barcode</th>

                        <th>SKU</th>

                        <th>Name</th>

                        <th>Quantity</th>

                        <th>Invoice Date</th>

                        <th>Invoice No</th>

                    </tr>

                </thead>

                <tbody>

                    @if(count($products))

                    @foreach($products as $product)

                   <?php $left = "(";

                   $right = ")" ;

                   $replace = array($left,$right,"/",".","-",",","*");

                   $replacement = array(" "," "," or ","",""," ","X");?>

                    <tr>

                        <td></td>
							
                        <td class="print-barcode" id="print-barcode-id-{{str_replace('+','plus',$product->custom_products->sku)}}"><img  src='data:image/png;base64,{{DNS1D::getBarcodePNG(substr($product->custom_products->sku,0,45), "C128", 3, 33, array(1, 1, 1), true)}}' width="160px" height="50px" id="print-barcode-id-{{str_replace('+','plus',$product->custom_products->sku)}}-child"></td>

                        <td id="print-id-{{$product->custom_products->id}}">{{$product->custom_products->sku}}</td>

                        <td>{{ucfirst($product->custom_products->name)}}</td>

                        <td>{{$product->quantity}}<div class="custom-margin"><input type="hidden" value="{{$product->quantity}}" name="table_qty[]" class="qty-box qty-box-{{str_replace('+','plus',$product->custom_products->sku)}}" >

                        <small class="help-block help-block-for-qty hide"  data-bv-for="qty_" data-bv-result="INVALID" style=""></small></div></td>

                        <td>{{date("d-m-Y g:i a", strtotime($product->date))}}</td>

                        <td>{{$product->invoice_no}}</td>  

                    </tr>

                    

                    @endforeach

                    @endif

                </tbody>

            </table>

        </div>

    </section>



@endsection

@section('javascript')



<script>

         var print_barcode_list_table = $('#print_barcode').DataTable( {

            dom: 'Bfrtip',

            buttons: [

            'selectAll',

            'selectNone',

            {

                text: 'Print Barcode',

                action: function ( e, dt, node, config ) { 

                    var data2 = print_barcode_list_table.rows( { selected: true } );

                    var doc = new jsPDF()

                    var left = 0;

                    var top=0;

                    var curr_qty = 1;

                    var margin_left = 10 ;

                    jQuery.each( data2.data(), function( i, val ) { 

                        

                        var divContents_name = data2.data()[i][3].substring(0,30);

                        var sku = data2.data()[i][2]; 

                        var divContents = data2.nodes().$('#print-barcode-id-'+data2.data()[i][2].replace('+','plus')+'-child')[0]['currentSrc'];

                        var qty = data2.nodes().$('.qty-box-'+data2.data()[i][2].replace('+','plus')).serializeArray()[0]['value'];

                        

                        console.log(data2.nodes()[i]['cells'][2]['id']);

                        for (var l = 1; l <= qty; l++) {

                                    doc.addImage(divContents, "png",margin_left

+(left*75),15+top , 40, 10)

                                    doc.setFontSize(12);

                                    doc.text(divContents_name,35+(left*70),30+top,null, null, "center");

                                    left++;

                                    margin_left = 5;

                                    if (curr_qty!== 0 & curr_qty % 3 == 0) {

                                         top=top+35;

                                         left=0;

                                         margin_left = 12;



                                    }

                                    if(curr_qty!== 0 & curr_qty % 24 == 0){

                                        doc.addPage("a4", "p");

                                        left=0;

                                        top=0;

                                        margin_left = 12; 



                                    }

                                    curr_qty++;

                        }

                        if(curr_qty % 24 == 0){

                            doc.addPage("a4", "p");

                                        left=0;

                                        top=0;



                        }

                        var pid = data2.nodes()[i]['cells'][2]['id'].substring(9);

                        var url = printBarcodeUrl+'?_token=' + $('meta[name="csrf-token"]').attr('content');

                        console.log(url);

                             $.ajax({

                                method: 'post',

                                url: url,

                                data: {id: pid , qty:qty},

                                success: function (data) {

                                    console.log(data);

                                },

                                error: function (data) {

                                    console.log('here2');

                                },

                            });

                        

                       

                    });

                doc.save('tanna_techbiz.pdf');  

                return false;

                }

            }

        ],

        

        paging:         true,

        fixedColumns:   {

            leftColumns: 2

        },

        columnDefs: [ {

            orderable: false,

            className: 'select-checkbox',

            targets:   0

        } ,

        { "orderDataType": "dom-text-numeric",

        targets:4},

       {"orderDataType": "date-time", "targets": [5]}

        ],

        

        select: {

            style:    'os',

            selector: 'td:first-child'

        },

        order: [[ 1, 'asc' ]]

    } );



</script>

@endsection