<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Company;
use App\Quotation;
use App\City;

use DB;

class QuotationDataController extends Controller
{
    public function getCompany(Request $request)
    {
		
		$search = $request['searchTerm'];
		$datas = Company::where('name','like','%'.$search.'%')->get();
		foreach($datas as $data){
			$result[] = array("id" => $data['id'],
				"text" => $data['name']);
		}
		return response()
            ->json($result);
    }

    public function getCompanyDetails(Request $request)
    {
		
		$company = $request['company'];
		$companydata = Company::where('id','=',$company)->first();
		return response()->json($companydata);
    }

    public function getCompanyBillingAddress(Request $request)
    {
		
		$company = $request['company'];
		$companydata = Company::where('id','=',$company)->first();
		$billingaddressdata = DB::table('company_addresses')
							->leftjoin('cities','cities.id','=','company_addresses.city')
							->leftjoin('states','states.state_id','=','company_addresses.state')
                            ->where('company_id','=',$company)
                            ->where('type','=','bill_to')
                            ->first();		 
		 
		return response()->json($billingaddressdata);
    }

    public function getCompanyShippingAddress(Request $request)
    { 
		
		$company = $request['company'];
		$companydata = Company::where('id','=',$company)->first();
		$shippingaddressdata = DB::table('company_addresses')
							->leftjoin('cities','cities.id','=','company_addresses.city')
							->leftjoin('states','states.state_id','=','company_addresses.state')
                            ->where('company_id','=',$company)
                            ->where('type','=','ship_to')
                            ->get();
							
		return response()->json($shippingaddressdata);
    }
    
    public function getproduct(Request $request)
    {
		
		$search = $request['searchTerm'];
		$datas = DB::table('custom_products')
			                ->where(DB::raw('lower(name)'),'like','%'.strtolower($search).'%')->get()->toArray();
		
		foreach($datas as $data){
			$result[] = array("id" => $data->id,
				"text" => $data->name);
		}
		return response()
            ->json($result);
    }

    public function getproductdetails(Request $request)
    {
		  $product = $request['product'];
		  $productdata = DB::table('custom_products')->where('id','=',$product)->first();
		  return response()->json($productdata);
    }

	public function ckeckprice(Request $request)
	{
		if($request->productid)
		{
			$productid=$request->productid;
			$unitcost=$request->unitcost;
			$checkcost=DB::table('custom_products')
					->where('id','=',$productid)
					->where('price','=',$unitcost)
					->count();
					if($checkcost > 0)
					{
					 echo 'allow';
					}
					else
					{
					 echo 'deny';
					}

		}
		
	}
 
	public function checkprice(Request $request)
	{

		$itemID=$request->itemid;
		$itemcost=$request->unitcost;

	
		$data=[];
		// for ($i = 0; $i < count($itemID); $i++) {
				
			$check=DB::table('custom_products')
					->where('id','=',$itemID)
					->where('price','=',$itemcost)
					->count();

			// if($check==0){
			// 	$data[] = ["id" => $itemID, "count" => $check];
			// }
        // }
		
		return response()->json($check);
	}

	public function getquotation(Request $request)
	{

		if($request->id){
		$quotationID=$request->id;
		
		$data=Quotation::find($quotationID);
        
		$company_details=DB::table('companies')->where('id','=',$data->company_id)->first();
   
  
		$product_details=DB::table('custom_products')
						->join("quotation_products","quotation_products.item_id","=","custom_products.id")
						->where('quotation_no','=',$data->quotation_no)
						->get();
 
        $billing_details=DB::table('company_addresses')
							->leftjoin('cities','cities.id','=','company_addresses.city')
                    		->leftjoin('states','states.state_id','=','company_addresses.state')
							->where('address_id','=',$data->billing_id)->first();
        $shipping_details=DB::table('company_addresses')
							->leftjoin('cities','cities.id','=','company_addresses.city')
                    		->leftjoin('states','states.state_id','=','company_addresses.state')
							->where('address_id','=',$data->shipping_id)->first();

		
		return response()->json(['data'=>$data,'company'=>$company_details,'product'=>$product_details,'billing'=>$billing_details,'shipping'=>$shipping_details]);

	
		}

		if($request->quotationno)
		{
		
			$quotationID=$request->quotationno;
		
			$data=DB::table('quotations')->where('quotation_no','=',$quotationID)->first();

			$company_details=DB::table('companies')->where('id','=',$data->company_id)->first();
   
  
			$product_details=DB::table('custom_products')
						->join("quotation_products","quotation_products.item_id","=","custom_products.id")
						->where('quotation_no','=',$data->quotation_no)
						->get();
 
        	$billing_details=DB::table('company_addresses')
							->leftjoin('cities','cities.id','=','company_addresses.city')
                    		->leftjoin('states','states.state_id','=','company_addresses.state')
							->where('address_id','=',$data->billing_id)->first();
        	$shipping_details=DB::table('company_addresses')
							->leftjoin('cities','cities.id','=','company_addresses.city')
                    		->leftjoin('states','states.state_id','=','company_addresses.state')
							->where('address_id','=',$data->shipping_id)->first();
        // return view('quotations.invoice',compact('data','company_details','product_details','billing_details','shipping_details'));

		 

		return response()->json(['data'=>$data,'company'=>$company_details,'product'=>$product_details,'billing'=>$billing_details,'shipping'=>$shipping_details]);
		}
	}

	public function Approval(Request $request,$value,$id)
	{
		if($value=="yes")
		{	
			$data=DB::table('quotations')->where('quotation_no','=',$id)->update(['conformation'=>'approved']);
			return view('pages.thank_you');
		}
		else
		{
			$data=DB::table('quotations')->where('quotation_no','=',$id)->update(['conformation'=>'disapproved']);
			return view('pages.thank_you');
		}
	}

	public function getproductname(Request $request)
    {
		
		$search = $request->listname;
		$datas = DB::table('custom_products')->where('id','like','%'.$search.'%')->get();
		
		return response()
            ->json($result);
    }

	public function setapproval(Request $request)
	{
		$id=$request->id;

		$set=DB::table('quotations')
			->where("id",$id)
			->update(
				
				['conformation'=>'approved']
			);


		return response()->json($set);
	}
	

	public function getCompanyfortable(Request $request)
	{
	
		$query=DB::table('companies')
				->select('name','company_code','gstin','email')
				->where("companies.deleted_at",null)
				->get();

				return response()->json(
					['data'=>$query]
				);

	}
}
 


