<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Quotation;
use App\Company;
use DB;

class QuotationController extends Controller
{
     function __construct()
    {
         $this->middleware('permission:quotation-list|quotation-create|quotation-edit|quotation-delete', ['only' => ['index','store']]);
         $this->middleware('permission:quotation-create', ['only' => ['create','store']]);
         $this->middleware('permission:quotation-edit', ['only' => ['edit','update']]);
         $this->middleware('permission:quotation-delete', ['only' => ['destroy']]);
    }
    
    public function index(Request $request)
    {
        $data=DB::table('companies')
                    ->rightjoin("quotations","quotations.company_id","=","companies.id")
                    ->where("quotations.deleted_at",null)
                    ->get();
        // $data=DB::table('quotations')
        //             ->leftjoin("companies","companies.id","=","quotations.company_id")
        //             ->where("quotations.deleted_at",null)
        //             ->get();
        

        // $data = Quotation::orderBy('id','DESC')->get();
        return view('quotations.index',compact('data'));
        
         
        
    }

    public function show(Request $request,$id)
    {
        $data=Quotation::find($id);

        $company_details=DB::table('companies')->where('id','=',$data->company_id)->first();

        $product_details=DB::table('quotations')
                    ->select('quotations.*','quotation_products.*','custom_products.name')
                    ->join('quotation_products','quotation_products.quotation_no','=','quotations.quotation_no')
                    ->rightjoin('custom_products','custom_products.id','=','quotation_products.item_id')
                     ->where('quotations.quotation_no','=',$data->quotation_no)
                    ->get();
  
        $billing_details=DB::table('company_addresses')
                        ->leftjoin('cities','cities.id','=','company_addresses.city')
                        ->leftjoin('states','states.state_id','=','company_addresses.state')
                        ->where('address_id','=',$data->billing_id)->first();

        $shipping_details=DB::table('company_addresses')
                        ->leftjoin('cities','cities.id','=','company_addresses.city')
                        ->leftjoin('states','states.state_id','=','company_addresses.state')
                        ->where('address_id','=',$data->shipping_id)->first();
        
        
        return view('quotations.show',compact('data','company_details','product_details','billing_details','shipping_details'));

        // return response()->json($quotations); 
         
         
    }

    public function invoicelayout(Request $request,$id)
    {
        $data=Quotation::find($id);
        $company_details=DB::table('companies')->where('id','=',$data->company_id)->first();
        $product_details=DB::table('quotation_products')->where('quotation_no','=',$data->quotation_no)->get();
        $billing_details=DB::table('company_addresses')->where('address_id','=',$data->billing_id)->first();
        $shipping_details=DB::table('company_addresses')->where('address_id','=',$data->shipping_id)->first();
        return view('quotations.invoice',compact('data','company_details','product_details','billing_details','shipping_details'));
    }

    public function update(Request $request)
    {
        return view('quotations.update');
    }
    
    public function store(Request $request)
    { 
       
        $quotations= new Quotation([  
            'quotation_no'=>$request->quotation_no,
            'company_id'=>$request->companyid,
            'billing_id'=>$request->billing_id,
            'shipping_id'=>$request->shipping_id,
            'issue_date'=>$request->issuedate,
            'generated_by'=>$request->generated_byquotation,
        ]);
        $quotations->save();
        
        return response()->json($quotations);
    }

    public function productstore(Request $request)
    {
	
       for($i =0; $i < count($request->quotation_itemid); $i++){
                $answers[] = [    
                    'quotation_no' =>$request->quotation_no1,
                    'item_id' => $request->quotation_itemid[$i],
                    'HSN'=>$request->quotation_HSN[$i],
                    'unit_cost' => $request->quotation_unitcost[$i],
                    'quantity' => $request->quotation_quantity[$i],
                    'c_s_gst' => $request->quotation_csgst[$i],
                    'i_gst' => $request->quotation_igst[$i],
                ];
        }
        
        $data=DB::table('quotation_products')->insert($answers);
		$affected = DB::table('quotations')
              ->where('quotation_no', $request->quotation_no1)
              ->update(['note' => $request->note]);
        
        return response()->json($data);

    }
    
    public function getmail(Request $request)
    {
        return view('quotations.mail');
    }
 
    public function destroy(Request $request)
    {
        if($request->gettingid)
        {
            $id=$request->gettingid;
            
            $check=DB::table('p_i_s')
                ->where("quotation_id",$id)
                ->count();
                
                if($check==1)
                {
                    echo 'not_deleteable';
                }
                else if($check==0)
                {
                    $quotations=Quotation::find($id);
                    if(!is_null($quotations))
                    {
                        $quotations->delete();
                    }
                    echo 'Deleted';
                }
        }

    }

    public function trash(Request $request)
    {
        
        $quotations=Quotation::onlyTrashed()->get();
        
        return response()->json($quotations); 
    }

    public function restore(Request $request)
    {
        $id=$request->gettingid;

        $quotations=Quotation::withTrashed()->find($id);
        
        if(!is_null($quotations))
        {
            $quotations->restore();
        }
        
        return response()->json($quotations); 
    }

    public function destroyperm(Request $request)
    {
        
        $id=$request->gettingid;

        $quotations=Quotation::withTrashed()->find($id);

        if(!is_null($quotations))
        {
            $quotations->forceDelete();
        }
        
        return response()->json($quotations); 
        
    }

    public function destroyunsaved(Request $request)
    {
            $id=$request->sessionforquotation;
            $quotations=Quotation::withTrashed()->find($id);        
                if(!is_null($quotations))
                {
                    $quotations->forceDelete();
                }
        
            return response()->json($quotations); 
    }

}
