<?php

namespace App\Http\Controllers;

use App\PI;
use Illuminate\Http\Request;

use DB;


class PIDataController extends Controller
{ 
     
    public function getquotation(Request $request)
    {
        $result=[];
        $usedQuotation=[];
        $search = $request['searchTerm'];
        $pi_quotation=DB::table('p_i_s')->get('quotation_id');
       if($pi_quotation){
           foreach($pi_quotation as $data){
			$usedQuotation[] =  $data->quotation_id;
				
		}
		$datas = DB::table('quotations')
                    ->whereNotIn('quotations.id',$usedQuotation)
                    ->where('quotations.deleted_at',null) //updated on 9-8-22
                    ->where('quotations.quotation_no','like','%'.$search.'%')
                    ->get();
         if(count($datas)){
            foreach($datas as $data){
    			$result[] = array("id" => $data->id,
    				"text" => $data->quotation_no);
    		}
         }                            
		
       }
        
      
        
   
		return response()
            ->json($result);
    }

    public function getpidetail(Request $request)
    {
        $pi_id=$request->pi_id;

        $data=PI::find($pi_id);        
        
        $quotation=DB::table('quotations')
                ->where('id','=',$data->quotation_id)
                ->first();

        $company=DB::table('companies')
                ->where('id','=',$quotation->company_id)
                ->first();
    
        $products=DB::table('quotations')
                    ->select('quotations.*','quotation_products.*','custom_products.name')
                    ->join('quotation_products','quotation_products.quotation_no','=','quotations.quotation_no')
                    ->rightjoin('custom_products','custom_products.id','=','quotation_products.item_id')
                    ->where('quotations.id','=',$data->quotation_id)
                    ->get();

        $billing_details=DB::table('company_addresses')
                ->leftjoin('cities','cities.id','=','company_addresses.city')
                ->leftjoin('states','states.state_id','=','company_addresses.state')
                ->where('address_id','=',$quotation->company_id)->first();

        $shipping_details=DB::table('company_addresses')
                        ->leftjoin('cities','cities.id','=','company_addresses.city')
                        ->leftjoin('states','states.state_id','=','company_addresses.state')
                        ->where('address_id','=',$data->pi_shippingid)->first();
            
        return response()->json(['data'=>$data,'quotation'=>$quotation,'company'=>$company,'product'=>$products,'billing'=>$billing_details,'shipping'=>$shipping_details]);        
    }
      
    public function getquotationdetail(Request $request)
    { 
        $quotation_id=$request->quotation;

        $data=DB::table('quotations')
            ->where("id","like",$quotation_id)
            ->first();
        $result=DB::table('companies')
            ->where("id","like",$data->company_id)
            ->first();
        $product_details=DB::table('custom_products')
            ->join("quotation_products","quotation_products.item_id","=","custom_products.id")
            ->where('quotation_no','=',$data->quotation_no)
            ->get();

        $billing_details=DB::table('company_addresses')
                            ->leftjoin('cities','cities.id','=','company_addresses.city')
                    		->leftjoin('states','states.state_id','=','company_addresses.state')
                            ->where('address_id','=',$data->billing_id)->first();
        $shipping_details=DB::table('company_addresses')
                            ->leftjoin('cities','cities.id','=','company_addresses.city')
                    		->leftjoin('states','states.state_id','=','company_addresses.state')
                            ->where('address_id','=',$data->shipping_id)->first();
 
        $shipping_select=DB::table('company_addresses')
                            ->leftjoin('cities','cities.id','=','company_addresses.city')
                    		->leftjoin('states','states.state_id','=','company_addresses.state')
                            ->where('company_id','=',$result->id)->where('type','ship_to')->get();

        $bank_detail=DB::table('bank_details')
                        ->get();

        return response()->json(['data'=>$data,'company'=>$result,'product'=>$product_details,'billing'=>$billing_details,'shipping'=>$shipping_details,'shipping_select'=>$shipping_select,'bank'=>$bank_detail]);
    }

    public function printoption(Request $request)
    {
        $pi_id=$request->id;
            
        $data=PI::find($pi_id);
        
        $quotation=DB::table('quotations')
                ->where('id','=',$data->quotation_id)
                ->first();

        $company=DB::table('companies')
                ->where('id','=',$quotation->company_id)
                ->first();
    
        $products=DB::table('quotations')
                    ->select('quotations.*','quotation_products.*','custom_products.name')
                    ->join('quotation_products','quotation_products.quotation_no','=','quotations.quotation_no')
                    ->rightjoin('custom_products','custom_products.id','=','quotation_products.item_id')
                    ->where('quotations.id','=',$data->quotation_id)
                    ->get();

        $billing_details=DB::table('company_addresses')
                ->leftjoin('cities','cities.id','=','company_addresses.city')
                ->leftjoin('states','states.state_id','=','company_addresses.state')
                ->where('address_id','=',$quotation->billing_id)->first();

        $shipping_details=DB::table('company_addresses')
                        ->leftjoin('cities','cities.id','=','company_addresses.city')
                        ->leftjoin('states','states.state_id','=','company_addresses.state')
                        ->where('address_id','=',$data->pi_shippingid)->first();
        $bank_detail=DB::table('bank_details')
                ->where('id','=',$data->bank_id)
                ->first();
            
        return response()->json(['data'=>$data,'quotation'=>$quotation,'company'=>$company,'product'=>$products,'billing'=>$billing_details,'shipping'=>$shipping_details,'bank'=>$bank_detail]);        
    }
}
  