<?php

namespace App\Http\Controllers;
use App\Iteams_attributes;
use App\Iteams;
use App\Attributes;

use Illuminate\Http\Request;
use DB;
use File;
 
class IteamsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $iteams=iteams::all();
       return view('iteams.index',compact('iteams')); 
    }
 
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Iteams $iteams,$id)
    {
       $iteams=iteams::find($id);
        $attributes=attributes::get();
        $data= attributes::join("iteams_attributes","iteams_attributes.attribute_id","=","attributes.id")
            ->where("iteams_attributes.product_id",$id)
            ->get();
        return view('iteams.create',compact('iteams','attributes','data'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        for ($i = 0; $i < count($request->get('attri_id')); $i++) {
            $answers[] = [
                'product_id'=>$request->item_id,
                'attribute_id' => $request->attri_id[$i],
                'attribute_value' => $request->attribute_value[$i]
            ];
        }
        iteams_attributes::insert($answers);
    
        /*$data=DB::table('iteams_attributes')->insert(
            ['attribute_id' => json_encode($request->get('attri_id'))],
            ['attribute_value' => json_encode($request->get('attribute_value'))]
        );*/
        return redirect()->route('iteams.index')
                        ->with('success','Iteam created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Iteams  $iteams
     * @return \Illuminate\Http\Response
     */
    public function show(Iteams $iteams,$id)
    {
        /*$iteams = iteams::find($id);
        return view('iteams.show',compact('iteams'));*/

        $iteams = iteams::find($id);
        $data= attributes::join("iteams_attributes","iteams_attributes.attribute_id","=","attributes.id")
            ->where("iteams_attributes.product_id",$id)
            ->get();
        return view('iteams.show',compact('iteams','data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Iteams  $iteams
     * @return \Illuminate\Http\Response
     */
    public function edit(Iteams $iteams,$id)
    {
        $iteams = iteams::find($id);
        $data= attributes::join("iteams_attributes","iteams_attributes.attribute_id","=","attributes.id")
            ->where("iteams_attributes.product_id",$id)
            ->get();
        return view('iteams.edit',compact('iteams','data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Iteams  $iteams
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Iteams $iteams,$id)
    {
         $iteams = iteams::find($id);
        
         for ($i = 0; $i < count($request->get('attri_id')); $i++) {
            $answers[] = [
                
                'attribute_value' => $request->attribute_value[$i]
            ];
        }
        iteams_attributes::insert($answers);
    
        return redirect()->route('iteams.index')
                        ->with('success','Permission updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Iteams  $iteams
     * @return \Illuminate\Http\Response
     */
    public function destroy(Iteams $iteams,$id)
    {
        $iteams = iteams::find( $id );
        $iteams ->delete();
        return redirect()->route('iteams.index')
                        ->with('success','Permission deleted successfully');
    }

   public function check(Request $request)
   {
   } 
    


}
