<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\InventoryInfo;
use Auth;
use App\Product;
use App\CustomProduct;
use App\PrintBarcodeLog;
use Session;

class InventoryController extends Controller {

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() {
        $products = InventoryInfo::with('custom_products', 'users')->orderby('date','desc')->get();
        return view('inventory.list', compact('products'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        //
    }

    public function dispatchProduct(Request $request) {
        return view('inventory.dispatchView');
    }
	
	public function sattelementProduct(Request $request) {
        return view('inventory.sattlementView');
    }

    public function saveDispatchProduct(Request $request) {

        $tot = count($request->sku_) - 1;
        for ($i = 0; $i < $tot; $i++) {
            $disp = new InventoryInfo();
            $disp->item_id = $request->product_id[$i];
            $disp->type = 'dispatch';
            $disp->quantity = $request->qty_[$i];
            $disp->scanned_by = Auth::user()->id;
            $disp->invoice_no = $request->invoice_number_[$i];
            $disp->save();

            $updateQty = CustomProduct::where(['id' => $request->product_id[$i]])->first();
            CustomProduct::where(['id' => $updateQty->id])->update(['qty' => $updateQty->qty - $request->qty_[$i]]);
        }
        Session::put('successMsg', 'Product Dispatched!');
        if (Auth::user()->id != 1) {
            return redirect()->route('home');
        } else {
            return redirect()->route('inventory');
        }
    }
	public function saveSattelmentProduct(Request $request) {

        $tot = count($request->sku_) - 1;
        for ($i = 0; $i < $tot; $i++) {
            $disp = new InventoryInfo();
            $disp->item_id = $request->product_id[$i];
            $disp->type = 'sattlement';
            $disp->quantity = $request->qty_[$i];
            $disp->scanned_by = Auth::user()->id;
            $disp->invoice_no = $request->invoice_number_[$i];
            $disp->save();

            $updateQty = CustomProduct::where(['id' => $request->product_id[$i]])->first();
            CustomProduct::where(['id' => $updateQty->id])->update(['qty' => $updateQty->qty + $request->qty_[$i]]);
        }
        Session::put('successMsg', 'Product Sattelment done!');
        if (Auth::user()->id != 1) {
            return redirect()->route('home');
        } else {
            return redirect()->route('inventory');
        }
    }

    public function checkIfQuantity(Request $request) {
        $product = CustomProduct::where(['id' => $request->id])->first();

        if ($product->qty < $request->qty) {
            $isQty = 0;
            $message = "Quantity required not available!";
        } else {
            $isQty = 1;
            $message = "";
        }

        $data = [
            'isQty' => $isQty,
            'message' => $message
        ];

        $formatted_tags[] = [
            'isQty' => $isQty,
            'message' => $message
        ];
        return \Response::json($formatted_tags);
    }
 
    public function searchInvoiceWithSKU(Request $request){
        $product = InventoryInfo::where(['item_id' => $request->id,'invoice_no'=>$request->invoice])->get();
        $valid = 1;
        $message = "";
        if(count($product)){
            $valid = 0;
            $message = "Product already entered in this invoice";
        }
        
        $rerurn_data = [
            'valid' => $valid,
            'message' => $message
        ];
        return \Response::json($rerurn_data);
    }
    
    public function printBarcode() {
        $products = InventoryInfo::with('custom_products')->where('type','=','receive')->orderby('date','desc')->get();
        
		return view('inventory.print_barcode', compact('products'));
    }
    
    public function logPrintBarcode(Request $request){
            $log = new PrintBarcodeLog();
            $log->product_id = $request->id;
            $log->quantity = $request->qty;
            $log->scanned_by = Auth::user()->id;
            $log->save();
    }
    
    public function viewBarcodePrintLog(){
        $logs = PrintBarcodeLog::with('custom_products', 'users')->orderby('created_at','desc')->get();
        return view('inventory.view_barcode_print_log', compact('logs'));
    }
}
