<?php

namespace App\Http\Controllers;
use Auth;
use DB;
use App\CustomProduct;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $quotations=count(DB::table('quotations')->where("quotations.deleted_at",null)->get());
        $invoice=count(DB::table('invoices')->where("invoices.deleted_at",null)->get());
        $companies=count(DB::table('companies')->where("companies.deleted_at",null)->get());
        $pi=count(DB::table('p_i_s')->where("p_i_s.deleted_at",null)->get());
        $users = count(DB::table('users')->where("users.deleted_at",null)->get());
		$products = CustomProduct::count();
        return view('home',compact('quotations','invoice','companies','pi','users','products'));
    }


    public function logout(Request $request) {
        Auth::logout();
        return redirect('/');
      }
    
}
