<?php

namespace App\Http\Controllers;

use App\Bank_details;
use DB;
use Illuminate\Http\Request;

class BankDetailsController extends Controller
{

    public function index()
    {
        $data=DB::table('bank_details')
                ->where("bank_details.deleted_at",null)
                ->get(); 

        return view('bank_detail.index',compact('data'));
    }

    public function store(Request $request)
    {
        $bank_details= new Bank_details([
            
            'bank_aliasname'=>$request->bank_aliasname,
            'bank_name'=>$request->bank_name,
            'bank_branch'=>$request->bank_branchname,
            'bank_ifsc'=>$request->bank_ifsc,
            'ac_no'=>$request->ac_no,
        ]);
        $bank_details->save();

        return response()->json($bank_details);
    }

    public function update(Request $request, Bank_details $bank_details)
    {
        $bank_details=Bank_details::where('id',$request->bank_id)
                ->update(
                    [
                        'bank_aliasname'=>$request->bank_aliasname,
                        'bank_name'=>$request->bank_name,
                        'bank_branch'=>$request->bank_branchname,
                        'bank_ifsc'=>$request->bank_ifsc,
                        'branch_code'=>$request->bank_branchcode,
                    ]
                );
    }

    public function getdetail(Request $request)
    {
        $bank_details=Bank_details::where('id',$request->bank_id)
                    ->first();

        return response()->json($bank_details);
    }

    public function destroy(Request $request)
    {
        $id=$request->bank_id;

            $bank_details=Bank_details::find($id);
            
            if(!is_null($bank_details))
            {
                $bank_details->delete();
            }
            
        return response()->json($bank_details);

    }

    public function restore(Request $request)
    {
            $id=$request->bank_id;

            $bank_details=Bank_details::withTrashed()->find($id);
            
            if(!is_null($bank_details))
            {
                $bank_details->restore();
            }
            
            return response()->json($bank_details); 

    }

    public function trash(Request $request)
    {

            $bank_details=Bank_details::onlyTrashed()->get();
        
            return response()->json($bank_details); 

    }

    public function destroyperm(Request $request)
    {

        $id=$request->bank_id;

        $bank_details=Bank_details::withTrashed()->find($id);
        
        if(!is_null($bank_details))
        {
            $bank_details->forceDelete();
        }
        
        return response()->json($bank_details); 
        
    }
}
