@extends('layouts.main')

@section('content')

<meta name="csrf-token" content="{{ csrf_token() }}">
<section class="content-header">
    <h1>Quotation Management</h1>
    <ol class="breadcrumb">
        <li><a href="/home"><i class="fa fa-dashboard"></i>Home</a></li>
        <li >Quotation</li>
        <li class="active">Show</li>
    </ol>
</section>
   
<hr style="border: 3px groove #3c8dbc;">

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-info">
                <div class="box-header">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <a class="btn btn-primary" href="{{ route('quotations.index') }}"> Back</a>                                
                            </div>
                        </div>
                    </div>
                </div>

                <div class="box-body">
                  <div class="invoice-show">
                    <div class="invoice-header">
                      @include('layouts/invoicePIQuotation/head')
                    </div>
					@include('layouts/invoicePIQuotation/header')
                    

                <div class="invoice-table">
                  <div class="row">
                    <table id="product_table" style="border: 2px solid black; height: 700px; width: 1000px;">
                      <thead style="border-bottom:2px solid black;">
                        <tr>
                          <th style="border-right: 1px solid black; width: 50px; text-align: center;">Sr NO.</th>
                          <th style="border-right: 1px solid black; text-align: center;">Product Name</th>
                          
                          <th style="border-right: 1px solid black; width: 95px; text-align: center;">HSN</th>
                          <th style="border-right: 1px solid black; width: 80px; text-align: center; ">GST(%)</th>
                          <th style="border-right: 1px solid black; width: 80px; text-align: center;">Quantity</th>
                          <th style="border-right: 1px solid black; width: 100px; text-align: center;">Unit Cost</th>
                          <th style="border-right: 1px solid black; width: 100px; text-align: center;">Total</th>
                        </tr>
                      </thead>
                      <tbody>
                      @php
                       $count=1;
                       $rowtotal=0.0;
                       $i_show=0;
                       $cs_show=0;
                       $gstvalue=0.0;
                       $rowgst=0.0;
                       $price=0.0;

                       $rowttl=0.0;

                       $subtotal=0.0;    
                       $gsttotal=0.0;
                       $grandtotalbfround=0.0;
                       $grandtotal=0.0;
                      @endphp
                        @foreach( $product_details as $value )
                        @php
                          if($value->c_s_gst=="null")
                          {
                            $i_show=1;
                            $gstvalue=trim($value->i_gst,"%");
                            $rowgst=($value->unit_cost/100)*($gstvalue)*($value->quantity);
                            $rowgst=number_format($rowgst,2);
                          }
                          elseif($value->i_gst=="null")
                          {
                            $cs_show=1;
                            $gststring=preg_replace('/[^A-Za-z0-9-+-.\-]/', ' ', $value->c_s_gst);
                            $gstvalue=strtok($gststring, '+');
                            $display=((float)$gstvalue*2);
                            $rowgst=($value->unit_cost/100)*(((int)$gstvalue)*2)*($value->quantity); 
                            $rowgst=number_format($rowgst,2);     
                          }
                            $rowtotal=$value->unit_cost*$value->quantity;
                            $rowttl=$rowtotal;
                            $rowtotal=number_format($rowtotal,2);
 
                            $subtotal=($subtotal+$rowttl);
                            
                            $gsttotal=((float)$gsttotal+((float)$rowgst));                            
                            
    
                            $grandtotalbfround=($subtotal)+($gsttotal);

                            $bfround=round($grandtotalbfround);
                            $roundvalue=($grandtotalbfround-$bfround);
                            $roundvalue=number_format($roundvalue,2);
                            
                            if($roundvalue < 0)
                            {
                              $grandtotal=$grandtotalbfround+-($roundvalue);
                              $grandttl=$grandtotalbfround+-($roundvalue); 
                              $roundvalue=-($roundvalue);

                              $grandtotal=number_format($grandtotal,2);
                            }
                            else if($roundvalue > 0)
                            {
                              $grandtotal=$grandtotalbfround-($roundvalue);
                              $grandttl=$grandtotalbfround-($roundvalue); 
                              $roundvalue=-($roundvalue);
                              $grandtotal=number_format($grandtotal,2);
                            }
                            else
                            {
                              $grandtotal=$grandtotalbfround; 
                              $grandttl=$grandtotalbfround; 
                              $grandtotal=number_format($grandtotal,2);
                            }                            
                            $words=getIndianCurrency($grandttl);
                            
                            $price=number_format($value->unit_cost,2);

                        @endphp                          
                        <tr style="line-height: 20px;">
                          <td style="border-right: 1px solid black; width: 50px; text-align: center;">{{$count}}</td>
                          <td style="border-right: 1px solid black; padding-left:2px; text-align: justify max-width: 80ch !important;word-break: break-word !important;hyphens: auto !important;;">{{ $value->name }}</td>
                          <td style="border-right: 1px solid black; width: 95px; text-align: center;">{{ $value->HSN }}</td>
                          @if($value->c_s_gst=="null")
                            <td style="border-right: 1px solid black; width: 80px; text-align: center;">{{ $value->i_gst }}</td>
                          @elseif($value->i_gst=="null")
                            <td style="border-right: 1px solid black; width: 80px; text-align: center;">{{ $display }}%</td>
                          @endif
                          <td style="border-right: 1px solid black; width: 80px; text-align: center;">{{ $value->quantity }}</td>
                          <td style="border-right: 1px solid black; width: 100px; text-align: right; padding-right:3px;">₹{{ $price }}</td>
                          <td style="border-right: 1px solid black; width: 100px; text-align: right; padding-right:3px;">₹{{ $rowtotal }}</td>                  
                        </tr>
                        @php
                          $count++;
                        @endphp
                        @endforeach
                      </tbody>
                    </table>
                  </div>
                </div>

                <div class="invoice-total" style="padding-left: 15px;">
                  <div class="row" style="height: 300px; width: 1063px;">
                    <div class="row" style=" height: 25px; width: 997px; border-bottom: 2px solid black; margin-left: 0px;">
                      <table>
                        <tbody>
                          <tr>
                            <td style="padding-left: 5px;"><b>OUR GSTIN:  24AALFT2125L1Z3 </b></td>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                    
                    <div class="col-md-8" style="border-right: 2px solid black; margin-left:0px; height:250px; border-bottom:2px solid black;">
                      
                      <div class="row" style="border-bottom: 2px solid black; height: 225px; ">
						    <label class="control-label" for="inputSuccess"> Note.</label>
							<div id="viewQuotationNote" >
							{{$data->note ? $data->note : ""}}
							</div>

                      </div>
                      <div class="row" style="padding-left: 15px;">
                        <table>
                          <tbody>
                            <tr>
                              <td><b>RS. {{ucwords($words)}}</b></td>
                            </tr>
                          </tbody>
                        </table>
                      </div>
                    </div>
 
                    <div class="col-md-4" style="padding-left: 0px; width:288px; height:250px; border-bottom:2px solid black;">
                      <table style="width: 288px;">
                        <tbody> 
                          <tr>
                            <td style=" text-align: right;"><b>Sub Total:</b></td>
                            <td style=" text-align: right; "><b>₹{{ $subtotal }}</b></td>
                          </tr>

                          @if($i_show==1)
                            <tr>
                              <td style=" text-align: right;"><b>IGST:</b></td>
                              <td style=" text-align: right; "><b>₹{{ $gsttotal }}<b></td>
                            </tr>
                          @elseif($cs_show==1)
                            <tr>
                              <td style=" text-align: right;"><b>SGST:</b></td>
                              <td style=" text-align: right; "><b>₹{{ $gsttotal/2 }}<b></td>
                            </tr>
                            <tr>
                              <td style=" text-align: right;"><b>CGST:</b></td>
                              <td style=" text-align: right; "><b>₹{{ $gsttotal/2 }}<b></td>
                            </tr>
                          @endif

                          <tr style="border-bottom: 2px solid black;">
                            <td style=" text-align: right;"><b>Round Off:</b></td>
                            <td style=" text-align: right; "><b>₹{{ $roundvalue }}</b></td>
                          </tr>
                          <tr>
                            <td style="width: 144px; text-align: right;"><b>Grand Total:</b></td>
                            <td style="width: 144px; text-align: right; "><b>₹{{ $grandtotal }}</b></td>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>

                <div class="invoice-term" style=" height: 150px; width: 100%;">
                  <div class="row">
                    <div class="col-md-9" >
                      <table style="font-size: 12px;">
                        
                      </table>
                </div>
                <div class="col-md-3" style="margin-left: -13px;">
                  <table>
                    <thead>
                      <tr>
                        <th style="text-align: center; padding-left: 35px;">For, Tanna TechBiz LLP</th>
                      </tr>
                    </thead>
                  </table>
                </div>
              </div>
            </div>
          </div>
                </div>

            </div>
        </div>
    </div>
</section>


@endsection