@extends('layouts.main')



@section('content')

<div class="content-wrapper">

    <!-- Content Header (Page header) -->

    <section class="content-header">

        <h1>

            Products

            <small>Edit Product</small>

        </h1>

        <ol class="breadcrumb">

            <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

            <li><a href="{{route('products')}}">Products</a></li>

            <li class="active">Edit</li>

        </ol>

    </section>

    <section class="content">

        <div class="box-body">

            

            {{Form::open(['route'=>array('update_product',$product->id,$type),'method'=>'post'])}}

            <div class="row custom-margin">

                <div class="col-md-6">

                    <div class="form-group">

                        <label>Name</label>

                        <input type="text" class="form-control product-name" style="width: 100%;" name="name" value="{{$product->custom_products->name}}" readonly>



                    </div>

                    <!-- /.form-group -->

                </div>

                <div class="col-md-6">

                    <div class="form-group">

                        <label>SKU</label>

                        <input type="text" class="form-control" style="width: 100%;" name="name" value="{{$product->custom_products->sku}}" readonly>

                        </select>

                    </div>

                    <!-- /.form-group -->

                </div>

            </div>

            <div class="row custom-margin">

                <div class="col-md-4">

                    <div class="form-group">

                        <label>Invoice No</label>

                        <input class="form-control" type="text" placeholder="Invoice No" name="invoice_no" value="{{$product->invoice_no}}">

                    </div>

                    <!-- /.form-group -->

                </div>

                <div class="col-md-4">

                    <div class="form-group">

                        <label>Invoice Date</label>

                        <input type="text" class="form-control pull-right date-only-custom" id="datepicker_invoice" name='invoice_date' placeholder="Select Date"  value="{{date('m/d/Y',strtotime($product->date))}}">

                    </div>

                    <!-- /.form-group -->

                </div>

                <div class="col-md-4">

                    <div class="form-group ">

                        <label>Quantity</label>

                        <input class="form-control print-qty number-only-custom" type="text" placeholder="Quantity" name="qty" value="{{$product->quantity}}" data-inv-type={{$type}} data-pid={{$product->custom_products->id}} data-value-old={{$product->quantity}}>

                        <small class="help-block help-block-for-qty hide" data-bv-for="qty_[]" data-bv-result="INVALID" style=""></small>

                    </div>

                </div>

            </div>

            @if($type == "receive")

            <div class="row">

                <div class="col-md-4">

                    <div class="form-group custom-print-barcode-parent" id="custom-print-barcode-parent">

                        <img alt="Barcode" src="data:image/png;base64,{{DNS1D::getBarcodePNG($product->custom_products->sku, "C39", 3, 33, array(1, 1, 1), false)}}" class="custom-barcode" width="160px" height="50px">

                    </div>

                </div>

                <div class="col-md-2">

                    <button  type="button" class="btn btn-block btn-primary custom-print-barcode">Print Barcode</button>

                </div>

                @endif

                <div class="col-md-2">

                    <button  type="submit" class="btn btn-block btn-primary custom-update">Update Product</button>

                </div>

            </div>

            {{Form::close()}}

        </div>

    </section>

</div>



@endsection

@section('javascript')



<script>

    $('#datepicker_invoice').datepicker({

        autoclose: true,

    });





    $(document).on('click', '.custom-print-barcode', function () {

        var divContents = document.getElementById("custom-print-barcode-parent");

        var qty = $('.print-qty').val();

        var divContents_name = $('.product-name').val();

        if (qty == '') {

            alert('Please enter quantity');

        } else if (divContents == '') {

            alert('Please select SKU');



        } else {



            var newWin = window.open('TannaTechBiz', 'Print-Window');

            newWin.document.open();

            newWin.document.write('<html>\n\

             <title>TannaTechBiz</title>\n\

             <body onload="window.print()">\n\

             <table><tr>');

            for (var i = 1; i <= qty; i++) {

                newWin.document.write('<td style="padding:10px;text-align:center">' + divContents.innerHTML + '<br>' + divContents_name + '</td>');

                if (i % 4 == 0) {

                    newWin.document.write('</tr><tr>');

                }

            }

            newWin.document.write('</tr></table>\n\

             </body>\n\

             </html>');

            newWin.document.close();

            setTimeout(function () {

                newWin.close();

            }, 10);

            $('.custom-save').removeClass('disabled');

            $('.custom-save').removeClass('hidden');

        }

    });

    

    

    $(document).on('keyup', '.print-qty', function () {

        var _this = $(this);

        console.log(_this.attr('data-pid'));

        console.log(_this.attr('data-inv-type'));

        var old_value = _this.attr('data-value-old');

    if(_this.attr('data-inv-type') == 'dispatch'){

    $.ajax({

        method: 'get',

        url: "{{route('check_quantity')}}",

        dataType: 'json',

        data: {id: _this.attr('data-pid'),

            qty: _this.val()

        },

        success: function (data) {

            if(_this.val() == old_value){

                    _this.parents('.custom-margin').find('.help-block-for-qty').addClass('hide');

                    $(document).find('.custom-update').prop('disabled', '');

                } 

            else if (data.length != 0) {

                console.log(data);

                if (data[0].isQty == 0) {

                    _this.parents('.custom-margin').find('.help-block-for-qty').removeClass('hide');

                    _this.parents('.custom-margin').find('.help-block-for-qty').html(data[0].message);

                    $(document).find('.custom-update').prop('disabled', 'disabled');

                    _this.val('');

                    _this.focus();



                }else{

                    _this.parents('.custom-margin').find('.help-block-for-qty').addClass('hide');

                    $(document).find('.custom-update').prop('disabled', '');

                }

            } else {

                _this.parents('.custom-margin').find('.help-block-for-qty').removeClass('hide');

                _this.parents('.custom-margin').find('.help-block-for-qty').html('Something went wrong!');

                _this.val('');

                _this.focus();

            }

        },

        error: function (data) {

            console.log(data);

            console.log('something went wrong');

        }

    });

    }

});

</script>

@endsection