@extends('layouts.main')

@section('content')

<section class="content-header">
    <h1>Iteams Management</h1>
    <ol class="breadcrumb">
        <li><a href="/home"><i class="fa fa-dashboard"></i>Home</a></li>
        <li><a href="#">Iteams</a></li>
        <li><a href="/iteams">Iteams List</a></li>
        <li class="active"><a href="#">Edit</a></li>
    </ol>
</section>

<hr style="border: 3px groove #3c8dbc;">


@if (count($errors) > 0)

    <div class="alert alert-danger">

        <strong>Whoops!</strong> There were some problems with your input.<br><br>

        <ul>

        @foreach ($errors->all() as $error)

            <li>{{ $error }}</li>

        @endforeach

        </ul>

    </div>

@endif

<section  class="content" >
    <div class="row"> 
        <div class="col-md-12">
            <div class="box box-primary">   
                {!! Form::model($iteams, ['method' => 'PATCH','route' => ['iteams.updateiteam', $iteams->id] ]) !!}
                    <div class="box-body">
                        
                        <div class="row">
                        <div class="form-group col-md-6">
                            <label>Product Name:</label>
                            
                            <b><u>{{ $iteams-> product_name }}</u></b>
                            <input type="hidden" name="item_id" value="{{$iteams->id}}">
                        </div>
                        </div>
                        
                        <div class="row">  
                        <div class="form-group col-md-6">
                            <label>Attribute:</label>
                            <br/>
                                @foreach($data as $value)
                                <label>
                                    <input type="hidden" name="attri_id[]" value="{{$value->id}}">
                                    
                                        {{ $value->attribute_name }}    
                                        
                                            {!! Form::text('attribute_value[]',$value->attribute_value, array('placeholder' => 'Attribute Value','class' => 'form-control')) !!}    
                                             
                                </label>
                                 
                                 <br/>
                                @endforeach
                        </div>
                    </div>
                    
                    
                        <div class="box-footer">
                            <a class="btn btn-primary" href="{{ route('iteams.index') }}"> Back</a>
                            <button type="submit" class="btn btn-primary pull-right">Submit</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
 
{!! Form::close() !!}


@endsection

