@extends('layouts.main')



@section('content')


    <!-- Content Header (Page header) -->

    <section class="content-header">

        <h1>

            Custom Products

            <small>New Custom Product</small>

        </h1>

        <ol class="breadcrumb">

            <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

            <li><a href="{{route('products')}}">Custom Products</a></li>

            <li class="active">Add</li>

        </ol>

    </section>

    <section class="content">

        <div class="box-body">

            {{Form::open(['route'=>'save_custom_product','method'=>'post','id'=>'add_custom_product'])}}

            <div class="row">

                <div class="col-md-5">

                    <div class="form-group">

                        <label>Name</label>

                    </div>

                    <!-- /.form-group -->

                </div>

                <div class="col-md-5">

                    <div class="form-group">

                        <label>SKU</label>

                    </div>

                    <!-- /.form-group -->

                </div>



            </div>

            <div class="row custom-margin box custom-box" >

                <div class="col-md-5">

                    <div class="form-group">

                        <input type="text" name="name[]" class="form-control custom-product-name" id="custom_name_1">

                        <small class="help-block help-block-for-name hide" data-bv-for="name[]" ></small>

                    </div>

                    <!-- /.form-group -->

                </div>

                <div class="col-md-5">

                    <div class="form-group">

                        <input type="text" name="sku[]" class="form-control sku" id="sku_1">

                        <small class="help-block help-block-for-sku hide" data-bv-for="sku[]" data-bv-result="INVALID" style=""></small>



                    </div>

                    <!-- /.form-group -->

                </div>

                <div class="col-md-1">

                    <button type="button" class="btn btn-default add-button "><i class="fa fa-plus"></i></button>

                </div>

            </div>

            <div class="row hide custom-margin box custom-box custom-clone" id="optionTemplate">

                <div class="col-md-5">

                    <div class="form-group">

                        <input type="text" name="name[]" class="form-control custom-product-name" id="custom_name_2">

                        <small class="help-block help-block-for-name hide" data-bv-for="name[]" ></small>



                    </div>

                    <!-- /.form-group -->

                </div>

                <div class="col-md-5">

                    <div class="form-group">

                        <input type="text" name="sku[]" class="form-control sku" id="sku_2">

                        <small class="help-block help-block-for-sku hide" data-bv-for="sku[]" data-bv-result="INVALID" style=""></small>



                    </div>

                    <!-- /.form-group -->

                </div>

                <div class="col-md-1">

                    <button type="button" class="btn btn-default add-button "><i class="fa fa-plus"></i></button>

                </div>

            </div>

            <div class="row">

                <div class="col-md-2">

                    <button  type="submit" class="btn btn-block btn-primary custom-save">Save</button>

                </div>

                <div class="col-md-2">

                    <a  href="{{route('products')}}" type="button" class="btn btn-block btn-danger button-cancel">Cancel</a>

                </div>

            </div>



            {{Form::close()}}

            

            

        </div>

    </section>

@endsection

@section('javascript')

<script>

    $('#add_custom_product').bootstrapValidator({

        fields: {

            'name[]': {

                validators: {

                    notEmpty: {

                        message: 'Name is required!'

                    },

                }

            },

            'sku[]': {

                validators: {

                    notEmpty: {

                        message: 'SKU is required!'

                    },

                }

            },

        }

    })

            .on('click', '.add-button', function () {

                $(this).removeClass('add-button').addClass('remove-button');

                $(this).parent().find('i').removeClass('fa-plus').addClass('fa-minus');

                $(document).find('#optionTemplate .custom-product-name').focus();

                var $template = $('#optionTemplate'),

                        $clone = $template.clone()

                        .removeClass('hide')

                        .removeAttr('id')

                        .insertBefore($template),

                        $option = $clone.find('[name="name[]"]');

                $option2 = $clone.find('[name="sku[]"]');

                // Add new field

                $('#add_custom_product').bootstrapValidator('addField', $option);

                $('#add_custom_product').bootstrapValidator('addField', $option2);

                var nameId = 'custom_name_' + $('.custom-clone').length;

                var skuId = 'sku_' + $('.custom-clone').length;

                $option.attr('id', nameId);

                $option2.attr('id', skuId);

                $($clone).find(".custom-product-name").focus();

            })

            .on('click', '.remove-button', function () {

                var $row = $(this).parents('.custom-margin')

//                $option = $row.find('[name="item_code[]"]');



                // Remove element containing the option

                $row.remove();

                // Remove field

//                $('#receiveItem').bootstrapValidator('removeField', $option);

//                $('#total_remove').val($('#total_remove').val() - 1);

            });

    $(document).on('change', '.custom-product-name', function () {

        var _this = $(this);

        var invalid = 0;

        $($(document).find('.custom-product-name')).each(function (i) {

            if (_this.val() == $(this).val() && $(this).attr('id') != _this.attr('id')) {

                invalid++;

            }



        });

        if (invalid) {

            _this.parents('.custom-margin').find('.custom-product-name').parents('.form-group').addClass('has-error');

            _this.parents('.custom-margin').find('.help-block-for-name').html('Duplicate Value for name');

            _this.parents('.custom-margin').find('.help-block-for-name').removeClass('hide');

            $(document).find('.custom-save').prop('disabled', 'disabled');

        } else {

//            $(document).find('.custom-save').prop('disabled', '');

//            _this.parents('.custom-margin').find('.help-block-for-name').addClass('hide');

//            _this.parents('.custom-margin').find('.custom-product-name').parents('.form-group').removeClass('has-error');

            $.ajax({

                url: '{{route("is_exist_product")}}',

                type: 'get',

                data: {data_info: _this.val(), data_type: 'name'},

                success: function (data) {

                    console.log(data);

                    if (data.isValid) {

                        $(document).find('.custom-save').prop('disabled', '');

                        _this.parents('.custom-margin').find('.help-block-for-name').addClass('hide');

                        _this.parents('.custom-margin').find('.custom-product-name').parents('.form-group').removeClass('has-error');



                    } else {

                        _this.parents('.custom-margin').find('.custom-product-name').parents('.form-group').addClass('has-error');

                        _this.parents('.custom-margin').find('.help-block-for-name').html(data.message);

                        _this.parents('.custom-margin').find('.help-block-for-name').removeClass('hide');

                        $(document).find('.custom-save').prop('disabled', 'disabled');

                    }

                }

            });

        }



    });



    $(document).on('change', '.sku', function () {

        var _this = $(this);

        var invalid = 0;

        $($(document).find('.sku')).each(function (i) {

            console.log('dsfsd');

            if (_this.val() == $(this).val() && $(this).attr('id') != _this.attr('id')) {

                invalid++;

            }



        });

        if (invalid) {

            _this.parents('.custom-margin').find('.sku').parents('.form-group').addClass('has-error');

            _this.parents('.custom-margin').find('.help-block-for-sku').html('Duplicate Value for sku');

            _this.parents('.custom-margin').find('.help-block-for-sku').removeClass('hide');

            $(document).find('.custom-save').prop('disabled', 'disabled');

        } else {

            $.ajax({

                url: '{{route("is_exist_product")}}',

                type: 'get',

                data: {data_info: _this.val(), data_type: 'sku'},

                success: function (data) {

                    console.log(data);

                    if (data.isValid) {

                        $(document).find('.custom-save').prop('disabled', '');

                        _this.parents('.custom-margin').find('.custom-product-sku').parents('.form-group').removeClass('has-error');

                        _this.parents('.custom-margin').find('.help-block-for-sku').addClass('hide');

                    } else {

                        _this.parents('.custom-margin').find('.sku').parents('.form-group').addClass('has-error');

                        _this.parents('.custom-margin').find('.help-block-for-sku').html(data.message);

                        _this.parents('.custom-margin').find('.help-block-for-sku').removeClass('hide');

                        $(document).find('.custom-save').prop('disabled', 'disabled');

                    }

                }

            });

//                $(document).find('.custom-save').prop('disabled', '');

//                _this.parents('.custom-margin').find('.help-block-for-sku').addClass('hide');

//                _this.parents('.custom-margin').find('.custom-product-sku').parents('.form-group').removeClass('has-error');

        }



    });





  

   </script>

@endsection