@extends('layouts.main')

@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">
<section class="content-header">
    <h1>Companies Management</h1>
    <ol class="breadcrumb">
        <li><a href="/home"><i class="fa fa-dashboard"></i>Home</a></li>
        <li class="active">Companies</li>
    </ol>
</section>
<hr style="border: 3px groove #3c8dbc;">
<section class="content-header">
       
</section>
<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-info">
                <div class="box-header" id="company_created">


                    <div class="alert alert-success hide" id="company_success"></div>
                    <div class="alert alert-danger hide" id="company_danger"></div>



                    <a class="btn btn-primary" href="{{ route('home') }}"> Back</a>
                    
                    <a class="btn btn-danger company_trash" href="#"> Go To Trash</a>
                    
                    @can('company-create')
                        <a class="btn btn-success pull-right company_create" href="#"> Add New Company</a>
                    @endcan
                
                    
                </div>
                <div class="box-body">
                    <table class="dataTables_wrapper form-inline dt-bootstrap" id="companies">
                        <thead>
                            <tr>
                                <th class="txt-center">No</th>
                                <th class="txt-center">Company Code</th>
                                <th class="txt-center">Company Name</th>
                                <th class="txt-center">GST NO</th>
                                <th class="txt-center">Email</th>
                                <th class="txt-center">Created Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($data as $value)
                            <tr>
                                <input type="hidden" class="editid" value="{{ $value->id }}">
                                <td class="txt-center"></td>
                                <td class="txt-center">{{ $value->company_code }}</td>
                                <td class="txt-center">{{ $value->name }}</td>
                                <td class="txt-center">{{ $value->gstin }}</td>
                                <td class="txt-center">{{ $value->email }}</td>
                                <td class="txt-center">{{ $value->created_at }}</td>
                                <td>
                                    @can('company-edit')
                                        <a class="dataid" data-id="{{ $value->id }}" style="cursor: pointer;"><i class="fa fa-edit green" title="Edit Company"></i></a>
                                    @endcan
                                    @can('company-delete')
                                       | <a class="deleteid" data-id="{{ $value->id }}" style="cursor: pointer;"><i class="fa fa-trash redcolor" title="Delete Company"></i></a>
                                    @endcan
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>
  
@include('companies.create')
@include('companies.edit')
@include('companies.trash')
@include('companies.addCity')

@endsection 