@extends('layouts.main')



@section('content')

<section class="content-header">

    <h1>Attributes Management</h1>

    <ol class="breadcrumb">

        <li><a href="/home"><i class="fa fa-dashboard"></i>Home</a></li>

        <li><a href="#">Iteams</a></li>

        <li class="active"><a href="#">Attributes</li>

    </ol>

</section>

<hr style="border: 3px groove #3c8dbc;">





<section class="content">

  <div class="row">

    <div class="col-xs-12">

      <div class="box box-info">

        <div class="box-header">

          <a class="btn btn-primary" href="{{ route('home') }}"> Back</a>

          

          @can('attribute-create')

          <a class="btn btn-success pull-right" href="{{ route('attributes.create') }}"> Create New Attributs</a>

          @endcan



        </div>

        <div class="box-body">

          <table class="dataTables_wrapper form-inline dt-bootstrap" id="attributes_table">

            <thead>

              <tr>

                <th>NO</th>

                <th>Attributes_Name</th>

                <th>Action</th>

                <th>NON Deletable</th>

              </tr>

            </thead>

            <tbody>

              @foreach($attributes as $display)

                <tr>

                  <td></td>

                  <td>{{ $display->attribute_name }}</td>

                  

                  

                  <td>

                      @can('attribute-edit')

                        <a  href="{{ route('attributes.edit',$display->id) }}"> <i class="fa  fa-pencil-square-o iconsize"></i></a>&nbsp

                      @endcan

                  

                      @can('attribute-delete')

                        @if($display->non_deletable==1)

                        <a  href="{{ route('attributes.delete',$display->id) }}" onclick="return confirm('Are you sure???')"> <i class="fa fa-trash-o red iconsize"></i></a>

                        @endif

                      @endcan



                  </td>



                  <td>

                    <div class="checkbox">

                      @if($display->non_deletable==1)



                        <input type="checkbox" class="defaultCheckbox" name="Non_Deletable" value="{{$display->id}}" checked>

                      

                      @else



                        <input type="checkbox" class="defaultCheckbox" name="Non_Deletable" value="{{$display->id}}">



                      @endif

                    </div>

                  </td>

                </tr>

                

                

                @endforeach

            </tbody>

            

          </table>

   

        </div>

      </div>

    </div>

  </div>

</section>



<script>



</script>

@endsection







