<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use App\User;
use App\CustomProduct;
use App\InventoryInfo;
class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);
        
        $inword = InventoryInfo::where(['type'=>'receive'])->sum('quantity');
                $dispatched = InventoryInfo::where(['type'=>'dispatch'])->sum('quantity');

        view()->share(['inword'=> $inword,'dispatched' => $dispatched]);
    }
}
